/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.ThreadState;
import org.python.core.TraceFunction;
import org.python.core.imp;

class PythonTraceFunction
extends TraceFunction {
    PyObject tracefunc;

    PythonTraceFunction(PyObject pyObject) {
        this.tracefunc = pyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TraceFunction safeCall(PyFrame pyFrame, String string, PyObject pyObject) {
        Class<imp> clazz = imp.class;
        synchronized (imp.class) {
            PythonTraceFunction pythonTraceFunction = this;
            synchronized (pythonTraceFunction) {
                ThreadState threadState = Py.getThreadState();
                if (threadState.tracing) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 6, 15] lbl9 : MonitorExitStatement: MONITOREXIT : var5_5
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return null;
                }
                if (this.tracefunc == null) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 6, 14] lbl13 : MonitorExitStatement: MONITOREXIT : var5_5
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return null;
                }
                PyObject pyObject2 = null;
                try {
                    threadState.tracing = true;
                    pyObject2 = this.tracefunc.__call__((PyObject)pyFrame, (PyObject)new PyString(string), pyObject);
                }
                catch (PyException pyException) {
                    pyFrame.tracefunc = null;
                    threadState.tracefunc = null;
                    threadState.profilefunc = null;
                    throw pyException;
                }
                finally {
                    threadState.tracing = false;
                }
                if (pyObject2 == this.tracefunc) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 6, 13] lbl30 : MonitorExitStatement: MONITOREXIT : var5_5
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return this;
                }
                if (pyObject2 == Py.None) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 6, 12] lbl34 : MonitorExitStatement: MONITOREXIT : var5_5
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return null;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 6] lbl37 : MonitorExitStatement: MONITOREXIT : var5_5
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return new PythonTraceFunction(pyObject2);
            }
        }
    }

    public TraceFunction traceCall(PyFrame pyFrame) {
        return this.safeCall(pyFrame, "call", Py.None);
    }

    public TraceFunction traceReturn(PyFrame pyFrame, PyObject pyObject) {
        return this.safeCall(pyFrame, "return", pyObject);
    }

    public TraceFunction traceLine(PyFrame pyFrame, int n) {
        return this.safeCall(pyFrame, "line", Py.None);
    }

    public TraceFunction traceException(PyFrame pyFrame, PyException pyException) {
        PyObject pyObject = pyException.traceback == null ? Py.None : pyException.traceback;
        return this.safeCall(pyFrame, "exception", new PyTuple(pyException.type, pyException.value, pyObject));
    }
}

